import { world, system } from '@minecraft/server'
import { Helper } from '../utils/Helper.js'
function onAfterPlayerSpawn(eventData) {
	if (eventData.player?.getDynamicProperty('sf_nba:player_first_spawn') == false) return;
	const player = eventData.player;
	player.setDynamicProperty('sf_nba:player_first_spawn', false);
	player.onScreenDisplay.setActionBar({ translate: 'action.sf_nba:book.appeared' });
	player.runCommandAsync('loot spawn ^^^2 loot "sf/nba/entities/info_book.loot"');
}
function onBeforePlayerInteractWithEntity(eventData) {
	const entity = eventData.target;
	if (eventData.itemStack?.typeId !== 'sf_nba:info_book') return;
	if (entity.typeId === 'sf_nba:info_book') return;
	const player = eventData.player;
	system.run(() => {
		Helper.decreaseMainhandItemStack(player);
		const pageNumber = entity.getProperty('sf_nba:recipe_page');
		const infoBookEntity = entity.dimension.spawnEntity('sf_nba:info_book', entity.location);
		infoBookEntity.setProperty('sf_nba:recipe_page', pageNumber);
	})
}
function onAfterItemUse(eventData) {
	if (eventData.itemStack?.typeId !== 'sf_nba:info_book') return;
	const player = eventData.source;
	player.runCommand('loot replace entity @s slot.weapon.mainhand 0 loot "sf/nba/info_book.loot"');
}
world.afterEvents.playerSpawn.subscribe(onAfterPlayerSpawn);
world.afterEvents.itemUse.subscribe(onAfterItemUse);
world.beforeEvents.playerInteractWithEntity.subscribe(onBeforePlayerInteractWithEntity);